/*
 * Decompiled with CFR 0.152.
 */
package cis.common.digsig.signer.service;

import cis.common.digsig.DigitalSigningFactory;
import cis.common.digsig.certificate.AbstractKeyStoreManager;
import cis.common.digsig.certificate.KeyStoreContainerType;
import cis.common.digsig.signature.AbstractDigitalSigner;
import cis.common.digsig.signature.SigningInstruction;
import cis.common.digsig.signer.service.KeyStoreConfiguration;
import cis.common.digsig.support.DocumentSignException;
import cis.common.digsig.support.SigningStandard;
import cis.common.digsig.support.SigningStrategy;
import java.security.cert.CertificateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignatureService {
    private final KeyStoreConfiguration configuration;

    @Autowired
    public SignatureService(KeyStoreConfiguration configuration) {
        this.configuration = configuration;
    }

    public String createSignature(String payload) {
        try {
            SigningInstruction si = DigitalSigningFactory.newSigningInstruction((SigningStandard)this.configuration.getSigningStandard(), (String)payload, (boolean)false, (SigningStrategy)this.configuration.getSigningStrategy());
            AbstractKeyStoreManager am = DigitalSigningFactory.newKeyStoreLoader((KeyStoreContainerType)this.configuration.getKeyStoreContainerType(), (String)this.configuration.getKeystoreLocation(), (String)this.configuration.getKeyStorePasscode(), (String)this.configuration.getKeyStoreAlias());
            AbstractDigitalSigner objectDigitalSigner = DigitalSigningFactory.newDigitalSigner((SigningInstruction)si, (AbstractKeyStoreManager)am);
            return objectDigitalSigner.signContent(si).getSignature();
        }
        catch (DocumentSignException | CertificateException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Exception has occurred while creating the signature.");
        }
    }
}

